/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.Map;

public class EventListenerList2
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Class<? extends EventListener>, LinkedHashMap<EventListener, Void>> listeners = Maps.newIdentityHashMap();

    public <T extends EventListener> Iterable<T> getListeners(Class<T> t) {
        LinkedHashMap<EventListener, Void> l = this.listeners.get(t);
        return l == null ? Collections.emptySet() : l.keySet();
    }

    public <T extends EventListener> Iterable<T> getListenersCopy(Class<T> t) {
        LinkedHashMap<EventListener, Void> l = this.listeners.get(t);
        return Lists.newArrayList(l.keySet());
    }

    public int getListenerCount() {
        int cnt = 0;
        for (LinkedHashMap<EventListener, Void> l : this.listeners.values()) {
            cnt += l.size();
        }
        return cnt;
    }

    public int getListenerCount(Class<?> t) {
        LinkedHashMap<EventListener, Void> l = this.listeners.get(t);
        return l == null ? 0 : l.size();
    }

    public <T extends EventListener> void add(Class<T> t, T listener) {
        LinkedHashMap<EventListener, Void> l = this.listeners.get(t);
        if (l == null) {
            l = Maps.newLinkedHashMap();
            this.listeners.put(t, l);
        }
        l.put(listener, null);
    }

    public <T extends EventListener> void remove(Class<T> t, T listener) {
        LinkedHashMap<EventListener, Void> l = this.listeners.get(t);
        if (l != null) {
            l.remove(listener);
        }
    }
}

